﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultSystemPlugin.Controls.Strategy
{
    public interface IAutoEndTasksStrategy
    {
        void Write(int i);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class AutoEndTasksDefaultStrategy : ICorrespondenceOS, IAutoEndTasksStrategy
    {
        public AutoEndTasksDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "AutoEndTasks";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion


        public void Write(int i)
        {
            RegistryKey registryKey =
                Registry.CurrentUser.CreateSubKey(
                    @"Control Panel\Desktop");

            registryKey.SetValue(RegName, i.ToString(),RegistryValueKind.String);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.CurrentUser.OpenSubKey(
                    @"Control Panel\Desktop");

            return new WFRegistry(@"HKEY_CURRENT_USER\Control Panel\Desktop", RegName,
                              registryKey.GetValue(RegName, "0"), RegistryValueKind.String, RegOperation.KeyWrite);



        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

    }

    public class AutoEndTasksController
    {
        public AutoEndTasksController(AutoEndTasks autoEndTasks,
                                                         IAutoEndTasksStrategy strategy)
        {
            AutoEndTasks = autoEndTasks;
            Strategy = strategy;
        }

        public AutoEndTasks AutoEndTasks { get; set; }
        public IAutoEndTasksStrategy Strategy { get; set; }

        public void Read()
        {
            AutoEndTasks.SetAutoEndTasksState(Convert.ToBoolean(Convert.ToInt32(Strategy.Read().Value)));
        }

        public void Write()
        {
            Strategy.Write(AutoEndTasks.GetAutoEndTasksState());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}
